#ifndef _CSG_STRUCTURE_H_
#define _CSG_STRUCTURE_H_

#include <stdint.h>

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE (!FALSE)
#endif

#define PHASE_NEEDED  2
#define GAIN_STAGES   1

//////////////////////////////////////////////////////////////////////////
/////////////////////basic type define///////////////////////////////////
/********** λ***********/
typedef struct
{
    unsigned char  bit0:1;
    unsigned char  bit1:1;
    unsigned char  bit2:1;
    unsigned char  bit3:1;
    unsigned char  bit4:1;
    unsigned char  bit5:1;
    unsigned char  bit6:1;
    unsigned char  bit7:1;
}__BITS8;                 //Byteλ

typedef struct
{
    unsigned int   bit0:1;
    unsigned int   bit1:1;
    unsigned int   bit2:1;
    unsigned int   bit3:1;
    unsigned int   bit4:1;
    unsigned int   bit5:1;
    unsigned int   bit6:1;
    unsigned int   bit7:1;
    unsigned int   bit8:1;
    unsigned int   bit9:1;
    unsigned int   bit10:1;
    unsigned int   bit11:1;
    unsigned int   bit12:1;
    unsigned int   bit13:1;
    unsigned int   bit14:1;
    unsigned int   bit15:1;
}__BITS16;                //Wordλ

typedef union
{
    unsigned char  Byte_V;
    __BITS8        Byte_bit;
}Char_Bit_type;

typedef union
{
    unsigned int Word_V;
    __BITS16 Word_bit;
}Word_Bit_type;

typedef union
{
    long          Value_L;
    unsigned char Byte[4];
}Type_Long_Array;


//////////////////////////////////////////////////////////////////////////
/////////////////////CSG structure define/////////////////////////////////
struct csg_phase_energy_parms_s
{
    uint32_t total_consumed_energy;
    uint32_t total_consumed_reactive_energy;     
    uint32_t total_consumed_negtive_energy;
    uint32_t total_consumed_negtive_reactive_energy;        
};

struct csg_metrology_parms_s
{
    //0: live; 1: neutral
  /*! \brief The active power, in steps of 0.01W */
    int32_t active_power[2];
    /*! \brief The reactive power, in steps of 0.01W */
    int32_t reactive_power[2];
    /*! \brief The apparent power, in steps of 0.01W */
    int32_t apparent_power[PHASE_NEEDED];
    /*! \brief The RMS voltage, in 10mV steps */
    uint16_t V_rms;
    /*! \brief The mains frequency, in steps of 1/100Hz */
    uint16_t frequency;
    /*! \brief The RMS current, in 1mA steps */
    uint16_t I_rms[2];
    /*! \brief The power factor, in steps of 0.001 */
    int16_t power_factor[PHASE_NEEDED];   
 
    struct csg_phase_energy_parms_s  energy;    
    
    int32_t V_dc_estimate;        
    int32_t I_dc_estimate[2];
    
};

/*! This structure contains the non-volatile parameters associated with a
    single current sensor (e.g a shunt resistor or a current transformer). */
struct csg_current_sensor_nv_parms_s
{
    /*! An offset to remove an approximation of the front end noise from the measured RMS
        current. */
    volatile int16_t Ac_offset;
    /*! The scaling factor between the raw RMS current value, and milliamps, when in
        normal operation. */
    volatile int16_t I_rms_scale_factor[GAIN_STAGES];
    
    /*! The scaling factor between the raw active power value, and 0.1W increments, when in
        normal operation. */
    volatile int16_t P_scale_factor[GAIN_STAGES];
    volatile int16_t Phase_correction[GAIN_STAGES];
    volatile int16_t Offset_active_power;
    volatile int16_t Offset_reactive_power;    
    
};

/*! This structure contains the non-volatile parameters associated with a phase. */
struct csg_phase_nv_parms_s
{
    /*! \brief The non-volatile information (e.g. calibration parameters) for a current channel. */
    struct csg_current_sensor_nv_parms_s current[2];
    /*! \brief The calibration scaling factor for the measured RMS voltage. */
    int16_t V_rms_scale_factor;
    /*! An initial value for the DC estimate, to ensure rapid settling after reset. */
    int32_t initial_I_dc_estimate[2];  
    /*! \brief A value used to prime the voltage signal DC estimate, to ensure quick settling, when the
               meter is powered up. It is set during the calibration process, based on the DC estimate
               measured at that time. */
    int32_t initial_v_dc_estimate;
};

/*! This structure contains configuration register content of CSG550. */
struct csg_config_parms_s
{
  /*! \system configuration */    
  int16_t gSysconf;
  /*! \AFE functions configuration */    
  int16_t gCsgconf;
  /*! \power constant for pulse*/    
  int16_t gPower_const;
  /*! \start current */    
  int16_t gStart_curr;

  uint8_t int_enable;
  uint8_t int_flag;  
  uint16_t status;  
  uint16_t chksum1; 
  uint16_t wren;      
};

/*! This structure holds all the working data for one phase. */
struct csg_phase_parms_s
{
    struct csg_phase_nv_parms_s  nv_parms;  
    struct csg_phase_nv_parms_s  nv_parms_new;  
    
    struct csg_metrology_parms_s  metrology;
    struct csg_config_parms_s config;
    struct csg_config_parms_s config_new;
    
    uint16_t meter_status;      
};

#endif